package com.forcs.zip;

import java.io.*;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ZipPasswordTest {
	
	String password = ""; // password ѱó ȵȴ.
	
	public static void main(String[] args) throws Exception
	{
		ZipPasswordTest test = new ZipPasswordTest();
		//test.test();
		test.createZipFile("C:/stest", "c:/PWedѱ.zip");
		test.unzip("c:/ziptest", "c:/PWedѱ.zip");

	}
	
	public void test() throws Exception {

		ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(new File("c:/PWedѱ.zip")));
		PrintWriter pw = new PrintWriter(new OutputStreamWriter(zos, "euc-kr"));
  
		zos.setPassword(password.getBytes());
  
		ZipEntry ze = new ZipEntry("ѱ1.txt");
  
		zos.putNextEntry(ze);
  
		pw.println("ȳϼ? ݰϴ.");
		pw.println("  йȣ  ZIP   ׽ƮԴϴ.");
  
          // Zip  (? ^^;)  Entry ݱ  о ִ´.  ׷   Ͽ ´.
		pw.flush();
  
          // Entry ݴ´.
		zos.closeEntry();
  
          // ׸  Entry.
		ze = new ZipEntry("ѱ/ѱ2.txt");
  
		zos.putNextEntry(ze);
  
		pw.println("ȳϼ? ݰϴ.");
		pw.println("  йȣ  ZIP   ׽ƮԴϴ.");
		pw.println("Zip    丮  Դϴ.");
  
		pw.flush();
  
		zos.closeEntry();
		zos.close();
  
		pw.close();
  
		System.out.println("йȣ ɸ Zip   Ϸ!");		 
		 
	}
	
	
    public void createZipFile(String path, String outFilename){
        long start = System.currentTimeMillis();
        path = replaceFileSeparator(path);
        outFilename = replaceFileSeparator(outFilename);
        try {
            // Create the ZIP file
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFilename)));
            
            out.setPassword(password.getBytes());
            if(path == null) throw new NullPointerException();

            File file = new File(path);

            if(!file.isDirectory()) System.out.println("file path is not directory");

//            File[] filenames = file.listFiles();

            int index = path.lastIndexOf("/");

            zip(out, new File[]{file}, index);


            // Complete the ZIP file
            out.close();

        } catch (NullPointerException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }finally{
            long end = System.currentTimeMillis();
            System.out.println("end - start = "+ (end-start)/1000 + "sec");
        }
    }

    private void zip(ZipOutputStream out, File[] filenames, int index) throws FileNotFoundException, IOException {
        int count = 0;
        for(int i=0; i<filenames.length; i++) {
            if(filenames[i].isDirectory()) {
                String filename = filenames[i].getAbsolutePath().substring(index+1);
                out.putNextEntry(new ZipEntry(filename+"/"));
                out.closeEntry();
                File[] subFiles = filenames[i].listFiles();
                zip(out, subFiles, index);
            }else {
                String filename = filenames[i].getAbsolutePath().substring(index+1);
                filezip(filename, new FileInputStream(filenames[i]), out);
                count++;
            }
        }

        if (count ==0) { // 

        }
    }

    private void filezip(String filename, FileInputStream in, ZipOutputStream out) throws FileNotFoundException, IOException {

        // Add ZIP entry to output stream.
        out.putNextEntry(new ZipEntry(filename));


        // Transfer bytes from the file to the ZIP file
        // Create a buffer for reading the files
        byte[] buf = new byte[2048];
        int len;
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }

        // Complete the entry
        out.closeEntry();
        in.close();
    }	
	
    
    private String replaceFileSeparator(String path) {
        StringBuffer tmp = new StringBuffer(path.substring(0, 1));
        StringTokenizer token = new StringTokenizer(path.substring(1,
            path.length()), "/\\");
        while (token.hasMoreTokens()) {
            tmp.append(token.nextToken() + "/");
        }

        if (tmp.charAt(tmp.length() - 1) == '/') {
            int len = tmp.length();
            tmp.replace(len - 1, len, "");
        }

        return tmp.toString();
    }
    
    
    public void unzip(String category, String targetZip) throws IOException {

        targetZip = replaceFileSeparator(targetZip);
        category = replaceFileSeparator(category);

        long beginTime = System.currentTimeMillis();
        byte[] buffer = new byte[2048];

        ZipFile zf = new ZipFile(new File(targetZip));
        zf.setPassword(password.getBytes());
         
        for (Iterator i = zf.getEntriesIterator(); i.hasNext();) {
        	ZipEntry ze = (ZipEntry) i.next();
         
        	String outputFileNm = ze.getName();
        	String fullpath = replaceFileSeparator(category + "/" + outputFileNm);
            File entryFile = new File(fullpath);
            
            if (ze.isDirectory()) 
            {
            	entryFile.mkdirs();
            }else 
            {
            	InputStream is = zf.getInputStream(ze);
            	
            	FileOutputStream foutput = new FileOutputStream(entryFile);
                int cnt;

                while ( (cnt = is.read(buffer)) != -1) {
                    foutput.write(buffer, 0, cnt);
                }
                foutput.flush();
                if (foutput != null) {
                    foutput.close();
                }
            	
            }
            
            
            
        }
        	        
        zf.close();

        long msec = System.currentTimeMillis() - beginTime;
        System.out.println("Unzipe Time Check :: >> " + msec / 1000 + "." + (msec % 1000) + " sec. elapsed...");
    }
}
