package com.forcs.zip;

import java.io.UnsupportedEncodingException;

public class ZipEntry extends java.util.zip.ZipEntry {
	private static final int PLATFORM_UNIX = 3;

	private String name;

	private String comment;

	protected String encoding;

	private int internalAttributes;

	private int platform;

	private int flag;

	private long externalAttributes;

	private byte[] centralDirectoryExtra;

	public ZipEntry(String name) {
		this(name, null);
	}

	public ZipEntry(String name, String encoding) {
		super("_dummy_");
		this.encoding = encoding;
		if (name == null) {
			throw new NullPointerException();
		}
		if (getBytes(name).length > 0xFFFF) {
			throw new IllegalArgumentException("entry name too long");
		}
		this.name = name;
	}

	public ZipEntry(java.util.zip.ZipEntry e) {
		this(e, null);
	}

	public ZipEntry(java.util.zip.ZipEntry e, String encoding) {
		super(e);
		this.encoding = encoding;

		this.name = e.getName();
		setComment(e.getComment());
	}

	void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return this.name;
	}

	public boolean isEncrypted() {
		return (getFlag() & 1) != 0;
	}

	public int getInternalAttributes() {
		return internalAttributes;
	}

	public void setInternalAttributes(int value) {
		internalAttributes = value;
	}

	public long getExternalAttributes() {
		return externalAttributes;
	}

	public void setExternalAttributes(long value) {
		externalAttributes = value;
	}

	public void setUnixMode(int mode) {
		setExternalAttributes(mode << 16 | ((mode & 128) != 0 ? 0 : 1)
				| (isDirectory() ? 16 : 0));
		platform = PLATFORM_UNIX;
	}

	public int getUnixMode() {
		return (int) (getExternalAttributes() >> 16 & 65535L);
	}

	public int getPlatform() {
		return platform;
	}

	protected void setPlatform(int platform) {
		this.platform = platform;
	}

	void setFlag(int flag) {
		this.flag = flag;
	}

	int getFlag() {
		return flag;
	}

	public void setComment(String comment) {
		if (comment != null && getBytes(comment).length > 0xffff) {
			throw new IllegalArgumentException("invalid entry comment length");
		}
		this.comment = comment;
	}

	public String getComment() {
		return comment;
	}

	public byte[] getLocalFileDataExtra() {
		byte extra[] = getExtra();
		return extra == null ? new byte[0] : extra;
	}

	public void setCentralDirectoryExtra(byte[] extra) {
		centralDirectoryExtra = extra;
	}

	public byte[] getCentralDirectoryExtra() {
		return centralDirectoryExtra == null ? new byte[0]
				: centralDirectoryExtra;
	}

	protected byte[] getBytes(String str) {
		if (str == null) {
			return null;
		}
		if (encoding == null) {
			return str.getBytes();
		} else {
			try {
				return str.getBytes(encoding);
			} catch (UnsupportedEncodingException e) {
				throw new RuntimeException(e.getMessage());
			}
		}
	}

	public boolean isDirectory() {
		return name.endsWith("/");
	}
}

class Offset {
	long offset, dataOffset;

	Offset(long offset) {
		this.offset = offset;
	}
}
