package com.forcs.zip;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ZipCloak extends InfoZIP_Crypt {

	public ZipCloak(File src) {
		zipfile = src;
	}

	public void decrypt(File dst, byte[] passwd) throws IOException {
		readzipfile(zipfile);
		RandomAccessFile inzip = null, outzip = null;
		try {
			inzip = new RandomAccessFile(zipfile, "r");
			outzip = new RandomAccessFile(dst, "rw");
			for (Zlist z = zfiles; z != null; z = z.nxt) {
				if ((z.flg & 1) != 0) {
					zipbare(z, inzip, outzip, passwd);
				} else {
					zipcopy(z, inzip, outzip);
				}
			}

			try {
				inzip.close();
			} catch (IOException e) {
			}
			inzip = null;

			last(outzip);
		} finally {
			if (inzip != null) {
				try {
					inzip.close();
				} catch (IOException e) {
				}
			}
			if (outzip != null) {
				try {
					outzip.close();
				} catch (IOException e) {
				}
			}
		}
	}

	public void encrypt(File dst, byte[] passwd) throws IOException {
		readzipfile(zipfile);
		RandomAccessFile inzip = null, outzip = null;
		try {
			inzip = new RandomAccessFile(zipfile, "r");
			outzip = new RandomAccessFile(dst, "rw");
			for (Zlist z = zfiles; z != null; z = z.nxt) {
				if ((z.flg & 1) == 0) {
					zipcloak(z, inzip, outzip, passwd);
				} else {
					zipcopy(z, inzip, outzip);
				}
			}

			try {
				inzip.close();
			} catch (IOException e) {
			}
			inzip = null;

			last(outzip);
		} finally {
			if (inzip != null) {
				try {
					inzip.close();
				} catch (IOException e) {
				}
			}
			if (outzip != null) {
				try {
					outzip.close();
				} catch (IOException e) {
				}
			}
		}
	}

	private void last(RandomAccessFile outzip) throws IOException {
		/* Write central directory and end of central directory */

		/* get start of central */
		int start_offset = (int) outzip.getFilePointer();

		for (Zlist z = zfiles; z != null; z = z.nxt) {
			putcentral(z, outzip);
		}

		/* get end of central */
		int length = (int) outzip.getFilePointer();

		length -= start_offset; /* compute length of central */
		putend(zcount, length, start_offset, zcomlen, zcomment, outzip);
	}

	public void setDosify(int dosify) {
		super.setDosify(dosify);
	}

	public void setFix(int fix) {
		super.setFix(fix);
	}

	public void setAdjust(int adjust) {
		super.setAdjust(adjust);
	}
}
