/*
 * Decompiled with CFR 0.152.
 */
package ozs.org.mozilla.javascript.optimizer;

import ozs.org.mozilla.javascript.CompilerEnvirons;
import ozs.org.mozilla.javascript.IRFactory;
import ozs.org.mozilla.javascript.JavaAdapter;
import ozs.org.mozilla.javascript.ObjToIntMap;
import ozs.org.mozilla.javascript.Parser;
import ozs.org.mozilla.javascript.ScriptRuntime;
import ozs.org.mozilla.javascript.ast.AstRoot;
import ozs.org.mozilla.javascript.ast.FunctionNode;
import ozs.org.mozilla.javascript.ast.ScriptNode;
import ozs.org.mozilla.javascript.optimizer.Codegen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCompiler {
    private String mainMethodClassName;
    private CompilerEnvirons compilerEnv;
    private Class<?> targetExtends;
    private Class<?>[] targetImplements;

    public ClassCompiler(CompilerEnvirons compilerEnv) {
        if (compilerEnv == null) {
            throw new IllegalArgumentException();
        }
        this.compilerEnv = compilerEnv;
        this.mainMethodClassName = "ozs.org.mozilla.org.mozilla.javascript.optimizer.OptRuntime";
    }

    public void setMainMethodClass(String className) {
        this.mainMethodClassName = className;
    }

    public String getMainMethodClass() {
        return this.mainMethodClassName;
    }

    public CompilerEnvirons getCompilerEnv() {
        return this.compilerEnv;
    }

    public Class<?> getTargetExtends() {
        return this.targetExtends;
    }

    public void setTargetExtends(Class<?> extendsClass) {
        this.targetExtends = extendsClass;
    }

    public Class<?>[] getTargetImplements() {
        return this.targetImplements == null ? null : (Class[])this.targetImplements.clone();
    }

    public void setTargetImplements(Class<?>[] implementsClasses) {
        this.targetImplements = implementsClasses == null ? null : (Class[])implementsClasses.clone();
    }

    protected String makeAuxiliaryClassName(String mainClassName, String auxMarker) {
        return String.valueOf(mainClassName) + auxMarker;
    }

    public Object[] compileToClassFiles(String source, String sourceLocation, int lineno, String mainClassName) {
        Parser p = new Parser(this.compilerEnv);
        AstRoot ast = p.parse(source, sourceLocation, lineno);
        IRFactory irf = new IRFactory(this.compilerEnv);
        ScriptNode tree = irf.transformTree(ast);
        irf = null;
        ast = null;
        p = null;
        Class<?> superClass = this.getTargetExtends();
        Class<?>[] interfaces = this.getTargetImplements();
        boolean isPrimary = interfaces == null && superClass == null;
        String scriptClassName = isPrimary ? mainClassName : this.makeAuxiliaryClassName(mainClassName, "1");
        Codegen codegen = new Codegen();
        codegen.setMainMethodClass(this.mainMethodClassName);
        byte[] scriptClassBytes = codegen.compileToClassFile(this.compilerEnv, scriptClassName, tree, tree.getEncodedSource(), false);
        if (isPrimary) {
            return new Object[]{scriptClassName, scriptClassBytes};
        }
        int functionCount = tree.getFunctionCount();
        ObjToIntMap functionNames = new ObjToIntMap(functionCount);
        int i = 0;
        while (i != functionCount) {
            FunctionNode ofn = tree.getFunctionNode(i);
            String name = ofn.getName();
            if (name != null && name.length() != 0) {
                functionNames.put(name, ofn.getParamCount());
            }
            ++i;
        }
        if (superClass == null) {
            superClass = ScriptRuntime.ObjectClass;
        }
        byte[] mainClassBytes = JavaAdapter.createAdapterCode(functionNames, mainClassName, superClass, interfaces, scriptClassName);
        return new Object[]{mainClassName, mainClassBytes, scriptClassName, scriptClassBytes};
    }
}

