/*
 * Decompiled with CFR 0.152.
 */
package ozs.org.mozilla.javascript.commonjs.module.provider;

import java.net.URI;
import java.util.LinkedList;
import ozs.org.mozilla.javascript.Context;
import ozs.org.mozilla.javascript.Scriptable;
import ozs.org.mozilla.javascript.commonjs.module.ModuleScript;
import ozs.org.mozilla.javascript.commonjs.module.ModuleScriptProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiModuleScriptProvider
implements ModuleScriptProvider {
    private final ModuleScriptProvider[] providers;

    public MultiModuleScriptProvider(Iterable<? extends ModuleScriptProvider> providers) {
        LinkedList<ModuleScriptProvider> l = new LinkedList<ModuleScriptProvider>();
        for (ModuleScriptProvider moduleScriptProvider : providers) {
            l.add(moduleScriptProvider);
        }
        this.providers = l.toArray(new ModuleScriptProvider[l.size()]);
    }

    @Override
    public ModuleScript getModuleScript(Context cx, String moduleId, URI uri, URI base, Scriptable paths) throws Exception {
        ModuleScriptProvider[] moduleScriptProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleScriptProvider provider = moduleScriptProviderArray[n2];
            ModuleScript script = provider.getModuleScript(cx, moduleId, uri, base, paths);
            if (script != null) {
                return script;
            }
            ++n2;
        }
        return null;
    }
}

